<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign hasMQEntity=false>
<#list sys.getAllPSDataEntities() as dataEntity>
<#if dataEntity.getAllPSDEDataSyncs?? && dataEntity.getAllPSDEDataSyncs()??>
    <#list dataEntity.getAllPSDEDataSyncs() as dataSync>
        <#if dataSync.getOutPSSysDataSyncAgent?? && dataSync.getOutPSSysDataSyncAgent()??>
            <#assign hasMQEntity=true>
            <#break>
        </#if>
    </#list>
</#if>
</#list>
<#if hasMQEntity>
package ${pub.getPKGCodeName()}.util.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.common.message.Message;
import lombok.extern.slf4j.Slf4j;
import ${pub.getPKGCodeName()}.util.domain.EntityBase;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import java.util.List;

/**
 * rocketMQ消息切面
 */
@Aspect
@Component
@Slf4j
public class RocketMQAspect
{
    private final ExpressionParser parser = new SpelExpressionParser();
    <#list sys.getAllPSDataEntities() as dataEntity>
        <#if dataEntity.getAllPSDEDataSyncs?? && dataEntity.getAllPSDEDataSyncs()??>
            <#list dataEntity.getAllPSDEDataSyncs() as dataSync>
                <#if dataSync.getOutPSSysDataSyncAgent?? && dataSync.getOutPSSysDataSyncAgent()??>
                    <#assign syncAgent=dataSync.getOutPSSysDataSyncAgent()>
                    <#assign producer=dataEntity.codeName+syncAgent.codeName+"producer">
    @Autowired
    @Qualifier("${producer}")
    @Lazy
    DefaultMQProducer ${producer};

    @AfterReturning(value = "(execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.create*(..))||execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.update*(..))||execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.save*(..)) ||execution(* ${pub.getPKGCodeName()}.core.*.service.*${dataEntity.codeName}*.remove*(..))) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.create*(..)) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.update*(..)) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.save*(..)) && !execution(* ${pub.getPKGCodeName()}.core.es.service.*.remove*(..))")
    @Async
    public void ${srfmethodname(producer)}(JoinPoint point) {
        <#if dataSync.getOutTestPSDEAction?? && dataSync.getOutTestPSDEAction()??>
        <#assign actionName=srfmethodname(dataSync.getOutTestPSDEAction().codeName)>
        outputAction(point, "${actionName}");
        </#if>
        sendMsg(${producer}, "${dataSync.codeName}", "${dataSync.codeName}", getEntity(point));
    }
                </#if>
            </#list>
        </#if>
    </#list>

    /**
     * 输出过滤行为
     * @param point
     * @param actionName
     */
    private void outputAction(JoinPoint point,String actionName) {
        Object [] args = point.getArgs();
        if(ObjectUtils.isEmpty(args) || args.length==0) {
            return;
        }
        Object arg = args[0];
        Object service = point.getTarget();
        EvaluationContext serviceCtx = new StandardEvaluationContext();
        serviceCtx.setVariable("service", service);
        serviceCtx.setVariable("arg", arg);
        Expression serviceExp = parser.parseExpression(String.format("#service.%s(#arg)", actionName));
        serviceExp.getValue(serviceCtx);
    }

    /**
     * 获取实体对象
     * @param point
     * @return
     */
    private Object getEntity(JoinPoint point) {
        Object entity=null;
        String action=point.getSignature().getName();
        Object [] args = point.getArgs();
        if(ObjectUtils.isEmpty(args) || args.length==0 || StringUtils.isEmpty(action)) {
            return entity;
        }
        Object arg=args[0];
        if(arg instanceof EntityBase  || arg instanceof List) {
            return arg;
        }
        else {
            return null;
        }
    }

    /**
     * 发送消息
     * @param producer
     * @param topic
     * @param tag
     * @param body
     */
    private void sendMsg(DefaultMQProducer producer, String topic, String tag, Object body) {
        if(ObjectUtils.isEmpty(body)) {
            log.error("发送消息失败，无法获取到要发送的消息内容！");
            return;
        }
        try {
            producer.start();
            Message message = new Message(topic, tag, JSON.toJSONString(body).getBytes());
            producer.send(message);
            producer.shutdown();
        } catch (Exception e) {
            log.error("消息发送异常，"+e);
        }
    }
}
</#if>